/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.lib.reactivex.rxjava3.internal.operators.flowable;

import dev.compactmods.crafting.lib.reactivestreams.Publisher;
import dev.compactmods.crafting.lib.reactivestreams.Subscriber;
import dev.compactmods.crafting.lib.reactivestreams.Subscription;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.FlowableSubscriber;
import dev.compactmods.crafting.lib.reactivex.rxjava3.disposables.Disposable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.exceptions.Exceptions;
import dev.compactmods.crafting.lib.reactivex.rxjava3.exceptions.MissingBackpressureException;
import dev.compactmods.crafting.lib.reactivex.rxjava3.flowables.ConnectableFlowable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.functions.Consumer;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.fuseable.HasUpstreamPublisher;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.util.BackpressureHelper;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.util.ExceptionHelper;
import dev.compactmods.crafting.lib.reactivex.rxjava3.operators.QueueSubscription;
import dev.compactmods.crafting.lib.reactivex.rxjava3.operators.SimpleQueue;
import dev.compactmods.crafting.lib.reactivex.rxjava3.operators.SpscArrayQueue;
import dev.compactmods.crafting.lib.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class FlowablePublish<T>
extends ConnectableFlowable<T>
implements HasUpstreamPublisher<T> {
    final Publisher<T> source;
    final int bufferSize;
    final AtomicReference<PublishConnection<T>> current;

    public FlowablePublish(Publisher<T> source, int bufferSize) {
        this.source = source;
        this.bufferSize = bufferSize;
        this.current = new AtomicReference();
    }

    @Override
    public Publisher<T> source() {
        return this.source;
    }

    @Override
    public void connect(Consumer<? super Disposable> connection) {
        PublishConnection<T> conn;
        boolean doConnect = false;
        while ((conn = this.current.get()) == null || conn.isDisposed()) {
            PublishConnection<T> fresh = new PublishConnection<T>(this.current, this.bufferSize);
            if (!this.current.compareAndSet(conn, fresh)) continue;
            conn = fresh;
            break;
        }
        doConnect = !conn.connect.get() && conn.connect.compareAndSet(false, true);
        try {
            connection.accept(conn);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            throw ExceptionHelper.wrapOrThrow(ex);
        }
        if (doConnect) {
            this.source.subscribe(conn);
        }
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        PublishConnection<Object> conn;
        while ((conn = this.current.get()) == null) {
            PublishConnection<T> fresh = new PublishConnection<T>(this.current, this.bufferSize);
            if (!this.current.compareAndSet(conn, fresh)) continue;
            conn = fresh;
            break;
        }
        InnerSubscription<T> inner = new InnerSubscription<T>(s, conn);
        s.onSubscribe(inner);
        if (conn.add(inner)) {
            if (inner.isCancelled()) {
                conn.remove(inner);
            } else {
                conn.drain();
            }
            return;
        }
        Throwable ex = conn.error;
        if (ex != null) {
            inner.downstream.onError(ex);
        } else {
            inner.downstream.onComplete();
        }
    }

    @Override
    public void reset() {
        PublishConnection<T> conn = this.current.get();
        if (conn != null && conn.isDisposed()) {
            this.current.compareAndSet(conn, null);
        }
    }

    static final class InnerSubscription<T>
    extends AtomicLong
    implements Subscription {
        private static final long serialVersionUID = 2845000326761540265L;
        final Subscriber<? super T> downstream;
        final PublishConnection<T> parent;
        long emitted;

        InnerSubscription(Subscriber<? super T> downstream, PublishConnection<T> parent) {
            this.downstream = downstream;
            this.parent = parent;
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.addCancel(this, n);
                this.parent.drain();
            }
        }

        @Override
        public void cancel() {
            if (this.getAndSet(Long.MIN_VALUE) != Long.MIN_VALUE) {
                this.parent.remove(this);
                this.parent.drain();
            }
        }

        public boolean isCancelled() {
            return this.get() == Long.MIN_VALUE;
        }
    }

    static final class PublishConnection<T>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Disposable {
        private static final long serialVersionUID = -1672047311619175801L;
        final AtomicReference<PublishConnection<T>> current;
        final AtomicReference<Subscription> upstream;
        final AtomicBoolean connect;
        final AtomicReference<InnerSubscription<T>[]> subscribers;
        final int bufferSize;
        volatile SimpleQueue<T> queue;
        int sourceMode;
        volatile boolean done;
        Throwable error;
        int consumed;
        static final InnerSubscription[] EMPTY = new InnerSubscription[0];
        static final InnerSubscription[] TERMINATED = new InnerSubscription[0];

        PublishConnection(AtomicReference<PublishConnection<T>> current, int bufferSize) {
            this.current = current;
            this.upstream = new AtomicReference();
            this.connect = new AtomicBoolean();
            this.bufferSize = bufferSize;
            this.subscribers = new AtomicReference<InnerSubscription[]>(EMPTY);
        }

        @Override
        public void dispose() {
            this.subscribers.getAndSet(TERMINATED);
            this.current.compareAndSet(this, null);
            SubscriptionHelper.cancel(this.upstream);
        }

        @Override
        public boolean isDisposed() {
            return this.subscribers.get() == TERMINATED;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.setOnce(this.upstream, s)) {
                if (s instanceof QueueSubscription) {
                    QueueSubscription qs = (QueueSubscription)s;
                    int m = qs.requestFusion(7);
                    if (m == 1) {
                        this.sourceMode = m;
                        this.queue = qs;
                        this.done = true;
                        this.drain();
                        return;
                    }
                    if (m == 2) {
                        this.sourceMode = m;
                        this.queue = qs;
                        s.request(this.bufferSize);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue<T>(this.bufferSize);
                s.request(this.bufferSize);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.sourceMode == 0 && !this.queue.offer(t)) {
                this.onError(new MissingBackpressureException("Prefetch queue is full?!"));
                return;
            }
            this.drain();
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
            } else {
                this.error = t;
                this.done = true;
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        void drain() {
            boolean async;
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            SimpleQueue<T> queue = this.queue;
            int consumed = this.consumed;
            int limit = this.bufferSize - (this.bufferSize >> 2);
            boolean bl = async = this.sourceMode != 1;
            block2: while (true) {
                if (queue != null) {
                    InnerSubscription<T>[] consumers;
                    long minDemand = Long.MAX_VALUE;
                    boolean hasDemand = false;
                    for (InnerSubscription<T> inner : consumers = this.subscribers.get()) {
                        long request = inner.get();
                        if (request == Long.MIN_VALUE) continue;
                        hasDemand = true;
                        minDemand = Math.min(request - inner.emitted, minDemand);
                    }
                    if (!hasDemand) {
                        minDemand = 0L;
                    }
                    while (minDemand != 0L) {
                        boolean empty;
                        T v;
                        boolean d = this.done;
                        try {
                            v = queue.poll();
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal(ex);
                            this.upstream.get().cancel();
                            queue.clear();
                            this.done = true;
                            this.signalError(ex);
                            return;
                        }
                        boolean bl2 = empty = v == null;
                        if (this.checkTerminated(d, empty)) {
                            return;
                        }
                        if (empty) break;
                        for (InnerSubscription<T> inner : consumers) {
                            if (inner.isCancelled()) continue;
                            inner.downstream.onNext(v);
                            ++inner.emitted;
                        }
                        if (async && ++consumed == limit) {
                            consumed = 0;
                            this.upstream.get().request(limit);
                        }
                        --minDemand;
                        if (consumers == this.subscribers.get()) continue;
                        continue block2;
                    }
                    if (this.checkTerminated(this.done, queue.isEmpty())) {
                        return;
                    }
                }
                this.consumed = consumed;
                if ((missed = this.addAndGet(-missed)) == 0) break;
                if (queue != null) continue;
                queue = this.queue;
            }
        }

        boolean checkTerminated(boolean isDone, boolean isEmpty) {
            if (isDone && isEmpty) {
                Throwable ex = this.error;
                if (ex != null) {
                    this.signalError(ex);
                } else {
                    for (InnerSubscription inner : this.subscribers.getAndSet(TERMINATED)) {
                        if (inner.isCancelled()) continue;
                        inner.downstream.onComplete();
                    }
                }
                return true;
            }
            return false;
        }

        void signalError(Throwable ex) {
            for (InnerSubscription inner : this.subscribers.getAndSet(TERMINATED)) {
                if (inner.isCancelled()) continue;
                inner.downstream.onError(ex);
            }
        }

        boolean add(InnerSubscription<T> inner) {
            InnerSubscription[] u;
            InnerSubscription<T>[] c;
            do {
                if ((c = this.subscribers.get()) == TERMINATED) {
                    return false;
                }
                int len = c.length;
                u = new InnerSubscription[len + 1];
                System.arraycopy(c, 0, u, 0, len);
                u[len] = inner;
            } while (!this.subscribers.compareAndSet(c, u));
            return true;
        }

        void remove(InnerSubscription<T> inner) {
            InnerSubscription<T>[] c;
            int len;
            while ((len = (c = this.subscribers.get()).length) != 0) {
                InnerSubscription[] u;
                int j = -1;
                for (int i = 0; i < len; ++i) {
                    if (c[i] != inner) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (len == 1) {
                    u = EMPTY;
                } else {
                    u = new InnerSubscription[len - 1];
                    System.arraycopy(c, 0, u, 0, j);
                    System.arraycopy(c, j + 1, u, j, len - j - 1);
                }
                if (!this.subscribers.compareAndSet(c, u)) continue;
                break;
            }
        }
    }
}

